Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[tutorial_basics.svg]]),
	Parameters =
	{
		MarineCount 		= 4,
		StartBPMultiplier 	= 10.7,     --Need to have this here to allow siege building
		BPGainMultiplier 	= 1.7,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 30.0,
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	}
}

ai_team = {}
player_team = {}

function ActivateStrikePlan(p_pointName, p_marineIndices)

	if p_marineIndices == nil then
		p_marineIndices = {}
		for i=1, #ai_team do
			table.insert(p_marineIndices, i)
		end
	end

	local strikeArea = GameWorld:GetEntityById(p_pointName);
	local marine = ai_team[3]:GetPtr();

	if not strikeArea then
		return
	end	
	
	
	for _,i in pairs(p_marineIndices) do
		local deltaV = vect2f.MakePolar(strikeArea:GetRadius()*3, i/#ai_team*math.pi*2)
		
		local marine = ai_team[i]:GetPtr();
		
		if marine then
			marine = marine:ToCHuman()
			
			if marine and not marine:GetIsBusy() then
				marine:CommandAssaultTo(strikeArea:GetPos() + deltaV)
			end
		end
	end

end

function BuildSiegeGun()

	local siegeGun = GameWorld:CreateEntity("AISiegeGun", "AISiegeGun", "siegePosition")
	siegeGun:ToCHumanBuilding():SetConstructionMultiplier(6.0)
	
	local marine = ai_team[3]:GetPtr();	
	if marine then
		marine = marine:ToCHuman()
		
		if marine then
			--marine:SendCommand(ICommandable.CT_ACTIVATE, siegeGun:GetPos(), siegeGun, true)
			marine:CommandActivate(siegeGun, siegeGun:GetPos())
		end
	end

end

Level.OnDebugCall = function (mousePos)
	ActivateStrikePlan("thirdpoint", {3,2})
end

backupOnPoint1 = false
backupOnPoint2 = false
backupOnPoint3 = false

function CheckAreaForPlayerMarines(p_areaId)

	local strikeArea = GameWorld:GetEntityById(p_areaId);

	if not strikeArea then
		return false
	end	
	
	for i=1, #player_team do
		local marine = player_team[i]:GetPtr();
		
		if marine then
			marine = marine:ToCHuman()
			
			if marine then
				if (strikeArea:GetPos() - marine:GetPos()):LengthSq() < strikeArea:GetRadius()*strikeArea:GetRadius() then
					return true
				end
			end
		end
	end	

	return false
end

function OnUpdate(p_milliseconds)

	if not backupOnPoint1 then
		if CheckAreaForPlayerMarines("backupArea1") then
			backupOnPoint1 = true
			ActivateStrikePlan("firstpoint")
			HiveKillGoal:Enable()			
		end
	end
	
	if not backupOnPoint3 and CaptureThirdGoal.enabled  then
		if CheckAreaForPlayerMarines("backupArea3") then
			backupOnPoint3 = true
			ActivateStrikePlan("thirdpoint", {3,5})			
		end
	end
	
	if not backupOnPoint2 and CaptureSecondGoal.enabled then
		if CheckAreaForPlayerMarines("backupArea2") then
			backupOnPoint2 = true
			ActivateStrikePlan("secondpoint")			
		end
	end

end
ScriptMgr:SetUpdateCallback(OnUpdate)

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		GameWorld:SetUIVisibility("ResourceGroup", false)
		GameWorld:SetUIVisibility("commandMenu", false)
		GameWorld:SetUIVisibility("constructionMenu", false)
		GameWorld:SetUIVisibility("MutationList", false)
		GameWorld:SetUIVisibility("Objectives", false)
		GameWorld:SetUIVisibility("researchMenu", false)
		GameWorld:SetUIVisibility("trainingMenu", false)
		GameWorld:SetUIVisibility("armouryMenu", false)
		GameWorld:SetUIVisibility("MarineTabGroup", false)
		GameWorld:SetUIVisibility("MarineSpawnGroup", false)
		
		
		--MarineSelectGoal:Enable()
		MarinePreSelectTrigger:Enable()
		MarinePreMoveTrigger:Enable()
		
		GameWorld:SetSpawnRate(30.0)
		GameWorld:SetSpawnRateScalingOn(false)
		
		for i=1,5 do		
			local entHandle = EHandle(GameWorld:GetEntityById("aiSoldier"..i));	
			table.insert(ai_team, entHandle)
		end
		
		--Set all player marines to have god mode
		local entCount = GameWorld:GetEntityCount()
		for i=0,entCount-1 do
			local ent = GameWorld:GetEntityByIndex(i)
			
			if ent then
				human = ent:ToCHuman()
				
				if human then --and human:GetIsPlayerControlled() then
					human:SetGodMode(true)
				end
				
				if human and human:GetIsPlayerControlled() then
					local entHandle = EHandle(human);	
					table.insert(player_team, entHandle)
				end				
			end
		end
		
		self:Disable()
	end)
LevelInit:Enable()

local experiencedPlayer1 = false
local experiencedPlayer2 = false
ScriptMgr:DoDelayedCall(7000, 	function ()
									if not experiencedPlayer1 then
										MarineSelectGoal:Enable()
									elseif not experiencedPlayer2 then
										MovementIntroGoal:Enable()			
									end
								end)

ScriptMgr:DoDelayedCall(5000, 	function ()
									if GetRandomRange(0.0,1.0) > 0.5 then
										local dir = vect2f(0.5,-1)
										local dest = GameWorld:GetEntityById("heliArea1"):GetPos()
										dir:Rotate(GetRandomRange(-0.5,0.5))
										
										local chopper = GameWorld:SpawnChopper(dir, dest)
										chopper:SetMission(ChopperOrder.CO_FLYBY, dest, "")
									end
									return true
								end)
								
ScriptMgr:DoDelayedCall(7000, 	function ()
									if GetRandomRange(0.0,1.0) > 0.5 then
										local dir = vect2f(-1.0,0.0)
										local dest = GameWorld:GetEntityById("heliArea2"):GetPos()
										dir:Rotate(GetRandomRange(-0.3,0.3))
										
										local chopper = GameWorld:SpawnChopper(dir, dest)
										chopper:SetMission(ChopperOrder.CO_FLYBY, dest, "")
									end
									return true
								end)
								
MarinePreSelectTrigger = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("exampleSoldier")
	end,
	
	{[[NT_ENTITY_SELECTION]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		experiencedPlayer1 = true
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("exampleSoldier")
	end)

MarinePreMoveTrigger = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_ENTITY_MOVE_COMMAND]], [[NT_ENTITY_ASSAULT_COMMAND]], [[NT_ENTITY_ATTACK_COMMAND]]},
	function (self, p_type, p_entId, p_pos, p_other)
		experiencedPlayer2 = true
				
		self:Disable()
	end) 

	
------------------------------------------------------------------------------- Select A Marine
MarineSelectGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Your HUD malfunctioning lieutenant?  We'd better run you through a couple of checks.\n\nLeft-click to select the marine to start", "Sarge")
	end,
	
	{[[NT_ENTITY_SELECTION]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		MovementGoal:Enable()
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("exampleSoldier")
	end)

------------------------------------------------------------------------------- Move A Marine (intro)
MovementIntroGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Your HUD malfunctioning lieutenant?  We'd better run you through a couple of checks.\n\nSelect a marine and right-click to order a move", "Sarge")
	end,
	
	{[[NT_ENTITY_MOVE_COMMAND]], [[NT_ENTITY_ASSAULT_COMMAND]], [[NT_ENTITY_ATTACK_COMMAND]]},
	function (self, p_type, p_entId, p_pos, p_other)
		DestroyGoal:Enable()
				
		self:Disable()
	end) 


------------------------------------------------------------------------------- Move A Marine
MovementGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Good, that worked.\n\nRight-click to order a move", "Sarge")
	end,
	
	{[[NT_ENTITY_MOVE_COMMAND]], [[NT_ENTITY_ASSAULT_COMMAND]], [[NT_ENTITY_ATTACK_COMMAND]]},
	function (self, p_type, p_entId, p_pos, p_other)
		DestroyGoal:Enable()
		
		self:Disable()
	end) 

------------------------------------------------------------------------------- Destroy Target
DestroyGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Almost done with the diagnostics\n\nGo and destroy that alien egg to check the guns", "Sarge")
		GameWorld:CreateEntity("DummyTarget", "dummytarget", "dummyMarker")
		GameWorld:CreateTrainingArrow("dummytarget")
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if p_entId ~= "dummytarget" then
			return
		end
		
		CameraMoveGoal:Enable()
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("dummytarget")
	end) 

------------------------------------------------------------------------------- Move Camera
CameraMoveGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Final bit.\n\nLook around by moving the mouse to the edge of the screen", "Sarge")
	end,
	
	{[[NT_MAP_SCROLL]]},
	function (self, p_type, p_entId, p_pos, p_other)
		--CameraZoomGoal:Enable()
		HiveKillGoal:Enable()
		
		self:Disable()
	end) 

------------------------------------------------------------------------------- Move Camera
HiveKillGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Why don't you help those army boys over there kill that alien hive?\n\nCan't let 'em have all the fun.", "Sarge")
		GameWorld:CreateTrainingArrow("firstpoint")
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
	
		local strikeArea = GameWorld:GetEntityById("firstpoint")
		if not strikeArea then
			return
		end
		
		local victimEnt = GameWorld:GetEntityById(p_entId)
		if not victimEnt then
			return
		end
				
		--Is the hive dead?
		if victimEnt:GetBuilding() and p_pos == strikeArea:GetPos() then
			GameWorld:ShowText("Hell yeah, look at those alien bits.  Time to wrap things up and lock this place down.\n\nOne of our grunts can do it by standing on top.", "Sarge")
			CaptureGoal:Enable() --Should be alredy enabled
			
			self:Disable()
		end
	end) 	

	

------------------------------------------------------------------------------- Zoom Camera
-- CameraZoomGoal = LevelUtils.MakeGoal(
	-- function (self)
		-- GameWorld:ShowText("Zoom in and out using the mouse wheel")
	-- end,
	
	-- {[[NT_MAP_ZOOM]]},
	-- function (self, p_type, p_entId, p_pos, p_other)
		-- GameWorld:ShowText("Capture the point by moving a soldier on top of it")
		-- GameWorld:CreateTrainingArrow("firstpoint")
		-- CaptureGoal:Enable() --Should be alredy enabled
		
		-- self:Disable()
	-- end) 	

------------------------------------------------------------------------------- Capture Point (short-circuit)
CaptureGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:RemoveTrainingArrow("firstpoint")
		CaptureAllGoal:Enable()
		
		BuildSiegeGun()
		
		LevelInit:Disable()
		MarineSelectGoal:Disable()
		MovementGoal:Disable()
		DestroyGoal:Disable()
		CameraMoveGoal:Disable()
		HiveKillGoal:Disable()
		--CameraZoomGoal:Disable()
		
		self:Disable()
	end) 
CaptureGoal:Enable()
	
------------------------------------------------------------------------------- Capture All Points 
CaptureAllGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("You're kicking alien ass now.  Why don't you mop up here and capture the entire sector?\n\nI'll see you back at base.", "Sarge")
		
		CaptureSecondGoal:Enable()
		CaptureThirdGoal:Enable()
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 

------------------------------------------------------------------------------- Capture Second Point
CaptureSecondGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("secondpoint")
		GameWorld:SetCapPointCapturable("secondpoint", true)
	end,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if  p_entId ~= "secondpoint" then
			return
		end
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("secondpoint")
	end) 
	
------------------------------------------------------------------------------- Capture Third Point
CaptureThirdGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("thirdpoint")
		GameWorld:SetCapPointCapturable("thirdpoint", true)
	end,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if  p_entId ~= "thirdpoint" then
			return
		end
	
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("thirdpoint")
	end) 

------------------------------------------------------------------------------- End